import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/my_color.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/core/utils/style.dart';
import 'package:viserpay/core/utils/util.dart';
import 'package:viserpay/data/controller/reward/reward_controller.dart';
import 'package:viserpay/data/model/reward/reward_response_model.dart';
import 'package:viserpay/view/components/app-bar/custom_appbar.dart';
import 'package:viserpay/view/components/bottom-sheet/custom_bottom_sheet.dart';
import 'package:viserpay/view/components/no_data.dart';
import 'package:viserpay/view/screens/reward/widget/claim_bottom_sheet.dart';
import 'package:viserpay/view/screens/reward/widget/reward_card.dart';

class RewardListScreen extends StatefulWidget {
  const RewardListScreen({super.key});

  @override
  State<RewardListScreen> createState() => _RewardListScreenState();
}

class _RewardListScreenState extends State<RewardListScreen> with SingleTickerProviderStateMixin {
  late TabController _tabController;

  @override
  void initState() {
    final controller = Get.put(RewardController(rewardRepo: Get.find()));
    _tabController = TabController(length: controller.levelRewards.length, vsync: this);
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      //   _tabController = TabController(length: controller.levelRewards.length, vsync: this);
    });
  }

  List<String> title = [
    MyStrings.earned,
    MyStrings.used,
    MyStrings.expired,
  ];

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: MyColor.screenBgColor,
      appBar: CustomAppBar(title: MyStrings.reward, isTitleCenter: true),
      body: GetBuilder<RewardController>(
        builder: (controller) {
          return Column(
            children: [
              SizedBox(height: Dimensions.space5),
              Expanded(
                child: DefaultTabController(
                  length: controller.levelRewards.length,
                  child: Column(
                    children: [
                      Container(
                        decoration: BoxDecoration(color: MyColor.colorWhite, borderRadius: BorderRadius.circular(Dimensions.defaultRadius)),
                        child: TabBar(
                          controller: _tabController,
                          labelColor: MyColor.primaryColor,
                          dividerColor: MyColor.getContentTextColor().withValues(alpha: 0.1),
                          unselectedLabelColor: MyColor.getContentTextColor(),
                          indicatorColor: MyColor.primaryColor,
                          isScrollable: true,
                          tabAlignment: TabAlignment.center,
                          labelPadding: EdgeInsetsDirectional.symmetric(vertical: Dimensions.space5, horizontal: Dimensions.space10),
                          tabs: List.generate(controller.levelRewards.length, (index) => Tab(text: controller.levelRewards[index].name ?? '')),
                          onTap: (value) {},
                        ),
                      ),
                      Expanded(
                        child: TabBarView(
                          physics: AlwaysScrollableScrollPhysics(parent: BouncingScrollPhysics()),
                          controller: _tabController,
                          children: List.generate(controller.levelRewards.length, (index) {
                            List<Reward> rewardList = controller.levelRewards[index].rewards ?? [];
                            return rewardList.isEmpty
                                ? NoDataWidget()
                                : Padding(
                                    padding: EdgeInsets.all(12),
                                    child: Column(
                                      spacing: 10,
                                      children: List.generate(
                                        rewardList.length,
                                        (rewardIndex) {
                                          final list = rewardList[rewardIndex];
                                          bool isDisable = (double.tryParse(controller.user?.totalPoints ?? "0.0") ?? 0.0) < (double.tryParse(list.requiredPoints ?? "0.0") ?? 0.0 + 1);
                                          printX("${list.name} -> ${list.requiredPoints}");
                                          return RewardCard(
                                            reward: list,
                                            isLoading: list.id == controller.selectedId,
                                            isUsed: controller.claimed(list.id.toString()),
                                            isDisable: isDisable,
                                            onTap: () {
                                              CustomBottomSheet(
                                                child: ClaimBottomSheet(
                                                  reward: rewardList[rewardIndex],
                                                  onTap: () {
                                                    Get.back();
                                                    controller.redeemReward(list);
                                                  },
                                                ),
                                              ).customBottomSheet(context);
                                            },
                                          );
                                        },
                                      ),
                                    ),
                                  );
                          }),
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            ],
          );
        },
      ),
    );
  }
}
